/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.web;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.minetogether.lib.web.ApiRequest;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.serverlist.data.ListType;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.util.ModPackInfo;

public class GetServerListRequest
extends ApiRequest<Response> {
    public GetServerListRequest(ListType listType, String userHash) {
        super("PUT", "https://api.creeper.host/serverlist/list", (Type)((Object)Response.class));
        this.requiredAuthHeaders.add("Fingerprint");
        this.requiredAuthHeaders.add("Identifier");
        ModPackInfo.VersionInfo info = ModPackInfo.getInfo();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("projectid", !info.base64FTBID.isEmpty() ? info.base64FTBID : info.curseID);
        body.put("listType", listType.name().toLowerCase());
        if (listType == ListType.INVITE) {
            body.put("hash", userHash);
        }
        this.jsonBody(body);
    }

    public static class Response
    extends ApiResponse {
        public List<Server> servers = new LinkedList<Server>();
    }
}

